/*

UNIX Permissions Calculator 1.1.1
Copyright  2007 Trevor Harmon <trevor@vocaro.com>

This file is licensed under the GNU General Public License.
http://www.gnu.org/copyleft/gpl.html

*/

var flipper;
var oldSymbolic;
var oldOctal;

function loaded() {
	flipper = new Fader(document.getElementById("flip"), null, 500);
	
	// Call the support function in System/Library/WidgetResources/button/genericButton.js
	// to create the "Done" button on backside
	createGenericButton (document.getElementById("doneButton"), "Done", showFront, 70);
	
	oldSymbolic = "---------";
	oldOctal = "0000";
}

function showBackside(event) {
	if (window.widget) {
		widget.prepareForTransition("ToBack");
	}
	document.getElementById("fliprollie").style.display="none";
	document.getElementById("front").style.display="none";
	document.getElementById("back").style.display="block";
	
	if (window.widget) {
		setTimeout("widget.performTransition()", 0);
	}
}	

function showFront(event) {
	if (window.widget) {
		widget.prepareForTransition("ToFront");
	}
	document.getElementById("back").style.display="none";
	document.getElementById("front").style.display="block";
	if (window.widget) {
		setTimeout("widget.performTransition()", 0);
	}
}

function recalculate()
{
	var symbolicString =
		(document.getElementById("symbolicOwnerRead").checked ? "r" : "-") +
		(document.getElementById("symbolicOwnerWrite").checked ? "w" : "-") +
		(document.getElementById("symbolicOwnerExecute").checked ? "x" : "-") +
		(document.getElementById("symbolicGroupRead").checked ? "r" : "-") +
		(document.getElementById("symbolicGroupWrite").checked ? "w" : "-") +
		(document.getElementById("symbolicGroupExecute").checked ? "x" : "-") +
		(document.getElementById("symbolicOtherRead").checked ? "r" : "-") +
		(document.getElementById("symbolicOtherWrite").checked ? "w" : "-");
		
	if (document.getElementById("symbolicSticky").checked) symbolicString += "t";
	else if (document.getElementById("symbolicOtherExecute").checked) symbolicString += "x";
	else symbolicString += "-";
	
	document.getElementById("symbolic").value = symbolicString;
	
	var octal = 
		(document.getElementById("symbolicOwnerRead").checked ? 400 : 0) +
		(document.getElementById("symbolicOwnerWrite").checked ? 200 : 0) +
		(document.getElementById("symbolicOwnerExecute").checked ? 100 : 0) +
		(document.getElementById("symbolicGroupRead").checked ? 40 : 0) +
		(document.getElementById("symbolicGroupWrite").checked ? 20 : 0) +
		(document.getElementById("symbolicGroupExecute").checked ? 10 : 0) +
		(document.getElementById("symbolicOtherRead").checked ? 4 : 0) +
		(document.getElementById("symbolicOtherWrite").checked ? 2 : 0) +
		(document.getElementById("symbolicOtherExecute").checked ? 1 : 0);
		
	if (document.getElementById("symbolicSticky").checked)
		octal += 1000;
	
	if      (octal < 10)   octalString = "000" + octal;
	else if (octal < 100)  octalString = "00" + octal;
	else if (octal < 1000) octalString = "0" + octal;
	else octalString = octal;
	
	document.getElementById("octal").value = octalString;
	
	oldSymbolic = document.getElementById("symbolic").value;
	oldOctal = document.getElementById("octal").value;
}

function recalculateFromSymbolic()
{
	var symbolicString = document.getElementById("symbolic").value;
	
	if (symbolicString.length == 9)
	{
		document.getElementById("symbolicOwnerRead").checked = symbolicString.charAt(0) == 'r';
		document.getElementById("symbolicOwnerWrite").checked = symbolicString.charAt(1) == 'w';
		document.getElementById("symbolicOwnerExecute").checked = symbolicString.charAt(2) == 'x';
		document.getElementById("symbolicGroupRead").checked = symbolicString.charAt(3) == 'r';
		document.getElementById("symbolicGroupWrite").checked = symbolicString.charAt(4) == 'w';
		document.getElementById("symbolicGroupExecute").checked = symbolicString.charAt(5) == 'x';
		document.getElementById("symbolicOtherRead").checked = symbolicString.charAt(6) == 'r';
		document.getElementById("symbolicOtherWrite").checked = symbolicString.charAt(7) == 'w';
		document.getElementById("symbolicOtherExecute").checked = symbolicString.charAt(8) == 'x';
		document.getElementById("symbolicSticky").checked = symbolicString.charAt(8) == 't';
		
		oldSymbolic = symbolicString;
		
		recalculate();
	}
	else
	{
		document.getElementById("symbolic").value = oldSymbolic;
	}
}

function recalculateFromOctal()
{
	var octalString = document.getElementById("octal").value;
	
	if (octalString.length == 4)
	{
		var symbolicString = "";
		
		for (i = 1; i <= 3; i++)
		{
			switch (octalString.charAt(i))
			{
				case '0': symbolicString += "---"; break;
				case '1': symbolicString += "--x"; break;
				case '2': symbolicString += "-w-"; break;
				case '3': symbolicString += "-wx"; break;
				case '4': symbolicString += "r--"; break;
				case '5': symbolicString += "r-x"; break;
				case '6': symbolicString += "rw-"; break;
				case '7': symbolicString += "rwx"; break;
			}
		}
		
		// Sticky bit...
		if (octalString.charAt(0) == '1')
		{
			symbolicString = symbolicString.substring(0, 8) + "t";
		}
		
		if (symbolicString.length == 9)
		{
			oldOctal = octalString;
			document.getElementById("symbolic").value = symbolicString;
			recalculateFromSymbolic();
			
			// Fix up weirdness caused by symbolic sticky conventions
			var other = octalString.charAt(3);
			if (other == 1 || other == 3 || other == 5 || other == 7)  // If other has execute bit set...
			{
				document.getElementById("symbolicOtherExecute").checked = true;
				recalculate();
			}
		}
		else
		{
			document.getElementById("octal").value = oldOctal;
		}
	}
	else
	{
		document.getElementById("octal").value = oldOctal;
	}
}
